// Outfit No. 1 Models
// Model 1.2 - Tricycle Delivery Truck / Triporteur / Driewielige bestelwagen / Dreiradriger Lieferwagen / Triciclo
// Alan Jardine, Kintore
// Version 1 - Complete - 2000-10-14


// Parts List - included for the record and as a possible future way of parameterising
// Meccano.inc to reduce parse time

// Qty.  4 of Part   2
// Qty.  2 of Part   5
// Qty.  1 of Part  11
// Qty.  4 of Part  12
// Qty.  1 of Part  16
// Qty.  1 of Part  18b
// Qty.  2 of Part  22
// Qty.  1 of Part  24
// Qty.  4 of Part  35
// Qty. 27 of Part  37a
// Qty. 24 of Part  37b
// Qty.  6 of Part  38
// Qty.  2 of Part  48a
// Qty.  1 of Part  52
// Qty.  2 of Part  90a
// Qty.  2 of Part 111c
// Qty.  2 of Part 126
// Qty.  2 of Part 126a
// Qty.  2 of Part 142c
// Qty.  1 of Part 193
// Qty.  2 of Part 194

#declare TricycleTruck =   

union { // Entire Model
  
        union { // Main Axle, Wheels & Tyres
               object {Part16}
               object {Part22 rotate  90*y translate -1.75*x}
               object {Part142c rotate <90,90,0> translate -1.75*x}
               object {Part22 rotate -90*y translate  1.75*x}
               object {Part142c rotate <90,90,0> translate  1.75*x}
               rotate 90*y                                             // Possible Animation variable
               translate -1*y                                             
              }              

        // Body Assembly
        
        union { // Entire Body
               union { // Base                                
                        union {
                               object {Part52}
                               object {Part37x rotate 180*x translate <-0.5,  1,0.05> }
                               object {Part37x rotate 180*x translate < 0.5,  1,0.05> }
                               object {Part37x rotate 180*x translate <-0.5, -1,0.05> }
                               object {Part37x rotate 180*x translate < 0.5, -1,0.05> }
                               object {Part37x rotate 0*x translate <1.5, 0,0> } // Steering Fulcrum
                               rotate -90*x
                              } 
                        // Axle Support
                        
                        union {
                               object {Part126 rotate 90*z translate <-3.25,0,0.025>}
                               rotate 90*z
                               translate <0,3.325,-1.325>
                              } 
                        
                        // Axle Support
                        union {
                               object {Part126 rotate 90*z translate <-3.25,0,0.025>}
                               rotate 90*z rotate 180*y
                               translate <0,3.325, 1.325>
                              }      
                     rotate <180,90,0>
                     }

        // Frontgate
        
        union {
               object {Part194 translate -0.025*z}
               object {Part48a rotate 180*x translate <0,0.5,0>}
               object {Part37x translate <   -1,0.5,0>}
               object {Part37x translate <    0,0.5,0>}
               object {Part37x translate <    1,0.5,0>}
               object {Part37x translate <-0.5,-0.5,0>}
               object {Part37x translate < 0.5,-0.5,0>}
               rotate 180*y
               translate <0,0.75,2.75>
              }
      
        // Tailgate
        
        union {
               object {Part194 translate -0.025*z}
               object {Part193 translate <0,1,-0.0125>}
               object {Part48a rotate 180*x translate <0,0.5,0>}
               object {Part37y translate < -0.5,0.5,-0.025>}
               object {Part38 rotate 90*y translate < -0.5,0.5,-0.075>}
               object {Part37y translate <  0.5,0.5,-0.025>}
               object {Part38 rotate 90*y translate < 0.5,0.5,-0.075>}
               object {Part37x translate <-0.5,-0.5,0>}
               object {Part37x translate < 0.5,-0.5,0>}
               union { // Handle
                      object {Part12}
                      object {Part111c rotate -90*y translate <0.05,0,-0.25>}
                      object {Part37a translate <-0.075,0,-0.25>}
                      translate <-0.75,0.5,-0.0325>
                     }
              union { // Handle
                      object {Part12}
                      object {Part111c rotate -90*y translate <0.05,0,-0.25>}
                      object {Part37a translate <-0.075,0,-0.25>}
                      rotate 180*z
                      translate <0.75,0.5,-0.0325>
                     }         
              translate <0,0.75,-2.75>
              } 
              
        // Side Strip
        union {
               object {Part2}
               object {Part37x translate -2.5*x}
               object {Part37x translate 2.5*x}
               rotate 90*y translate <-1.25,1.25,0>
              } 
        // Side Strip
        union {
               object {Part2}
               object {Part37x translate -2.5*x}
               object {Part37x translate 2.5*x}
               rotate -90*y translate <1.25,1.25,0>
              }                                                  
        rotate <0,-90,0>
        }
        

        // Saddle & Rear Wheel Assembly
        
        union {
                // Side Member at Front 
                union {
                        object {Part2}
                        object {Part37x translate -2*x}
                        object {Part90a rotate 127*z translate <2.92,1.625,-0.05>}
                        union {
                                object {Part5}
                                object {Part37x translate -1*x}
                                object {Part37x translate  1*x}
                                rotate 50*z translate <0.65,0.8225,-0.025>
                              } 
                        translate <0,0,-0.275>
                      }  
                      
                // Side Member at Rear       
                union {
                        object {Part2}
                        object {Part37x rotate 180*x translate -2*x}
                        object {Part90a rotate 127*z translate <2.92,1.625,0.05>}
                        union {
                                object {Part5}
                                object {Part37y translate -1*x}
                                object {Part37y translate  1*x}
                                rotate 180*x
                                rotate 50*z translate <0.65,0.8225,0.025>
                              } 
                        translate <0,0,0.275>
                      } 
                            
        object {Part11 rotate <-105,90,0> translate <-2,0.25,0>}
        
        // Saddle
        union {
                object {Part12 rotate -75*z translate <1.275,1.9,0.25>}
                union {
                        object {Part126a}
                        object {Part37y rotate -75*z translate -0.5*y}
                        rotate 90*y rotate -75*z translate <1.75,2.1,0>
                      } 
                object {Part12 rotate -105*z rotate 180*y  translate <1.275,1.9,-0.25>}
        
        }
        union {
               object {Part18b rotate 90*y} // Axle
               object {Part24 rotate -70*z translate -0.125*z }  // Wheel
               translate 2.5*x
              } 
        rotate <0,10,-8.5> translate <3.5,-0.7,-0.25>
        }  
        
} // End of Entire Model        
        


 